<?php
session_start();

if (isset($_POST["send"])) {
    // Save input values to session
    $_SESSION['form_data'] = [
        'name'    => $_POST['name'],
        'email'   => $_POST['email'],
        'subject' => $_POST['subject'],
        'message' => $_POST['message']
    ];

    $name    = $_POST['name'];
    $email   = $_POST['email'];
    $subject = $_POST['subject'];
    $message = $_POST['message'];

    // === reCAPTCHA Verification ===
    $recaptchaSecret = "6Leo81ErAAAAADKSxwEM1c46HXBPQDgPqj_fDtGp";
    $recaptchaResponse = $_POST['g-recaptcha-response'];

    if (empty($recaptchaResponse)) {
        $_SESSION['message'] = "Please verify that you're not a robot.";
        $_SESSION['status'] = "error";
        header("Location: index.php#contact");
        exit();
    }

    // Verify with Google
    $verifyUrl = 'https://www.google.com/recaptcha/api/siteverify';
    $data = [
        'secret'   => $recaptchaSecret,
        'response' => $recaptchaResponse,
        'remoteip' => $_SERVER['REMOTE_ADDR']
    ];

    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data)
        ]
    ];

    $context  = stream_context_create($options);
    $verify   = file_get_contents($verifyUrl, false, $context);
    $captchaSuccess = json_decode($verify);

    if (!$captchaSuccess->success) {
        $_SESSION['message'] = "CAPTCHA verification failed.";
        $_SESSION['status'] = "error";
        header("Location: index.php#contact");
        exit();
    }

    // === Email validation ===
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $_SESSION['message'] = "Invalid email address.";
        $_SESSION['status'] = "error";
        header("Location: index.php#contact");
        exit();
    }

    // === Email sending ===
    $to = "post@tisarana.no";
    $headers = "From: $email\r\n";
    $headers .= "Reply-To: $email\r\n";

    if (mail($to, $subject, $message, $headers)) {
        $_SESSION['message'] = "Sent successfully!";
        $_SESSION['status'] = "success";
        unset($_SESSION['form_data']); // Clear form data on success
        header("Location: index.php#contact");
        exit();
    } else {
        $_SESSION['message'] = "Sending failed.";
        $_SESSION['status'] = "error";
        header("Location: index.php#contact");
        exit();
    }
}
?>
