<?php session_start(); ?>
<?php if (isset($_SESSION['message']) && isset($_SESSION['status'])): ?>
  <style>
    .custom-alert {
      position: fixed;
      bottom: 20px;
      left: 50%;
      transform: translateX(-50%);
      z-index: 9999;
      padding: 10px 20px;
      border-radius: 5px;
      font-weight: 500;
      border: 1px solid transparent;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    }

    .alert-success {
      background-color: #28a745;
      color: white;
    }

    .alert-error {
      background-color: #EF4444;
      color: white;
    }
  </style>

  <div id="alertBox" class="custom-alert alert-<?php echo $_SESSION['status']; ?>">
    <?php echo htmlspecialchars($_SESSION['message']); ?>
  </div>

  <script>
    setTimeout(function () {
      var alertBox = document.getElementById('alertBox');
      if (alertBox) {
        alertBox.style.opacity = '0';
        alertBox.style.transition = 'opacity 0.5s ease-out';
        setTimeout(function () {
          alertBox.style.display = 'none';
        }, 500);
      }
    }, 3000);
  </script>

  <?php
  unset($_SESSION['message'], $_SESSION['status']);
  ?>
<?php endif; ?>


  
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Tisarana Sri Lanka Buddhist Vihara</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
  <link rel="icon" href="favicon.ico" type="image/png">
  <script src="https://www.google.com/recaptcha/api.js" async defer></script>

  <style>
    /* Body and Background */
    body {
      background-color: #F5F5F5;
      color: #333;
    }
	.navbar .nav-link, h2 {
  font-weight: bold;
}
@media (max-width: 991.98px) {
  .navbar-collapse {
    text-align: right;
  }
  .navbar-nav .nav-link {
    padding-right: 1rem;
  }
}



    /* Navbar Customization */
    .navbar {
       background-color: transparent !important;
  box-shadow: none; /* optional: removes shadow if any */
      
    }
    .navbar a {
      color: #F5F5F5 !important;
      font-weight: bold;
      
    }
	.navbar .nav-link:hover {
  color: #555555 !important; /* Dark yellow */
}

.navbar.scrolled {
  background-color: #333333 !important;
  transition: background-color 0.6s ease;
}


    /* Header Section */
    .header {
      background-color: #ff6600; /* Orange */
      color: white;
      padding: 10px 0;
      text-align: center;
    }

    /* Footer Section */
    footer {
      background-color: #ddd; /* Orange */
      color: white;
      padding: 20px 0;
      text-align: center;
    }

    /* Button Customization */
    .btn-primary {
      background-color: #333333;
      border-color: #333333;
    }
    .btn-primary:hover {
      background-color: #333333;
      border-color: #333333;
    }

    /* Form Inputs */
    .form-control {
      
      border-radius:4;
    }
    .form-control:focus {
      
      box-shadow: #333333;
    }
	.bg-orange {
 
}

h2, h5 {
  color: #F5F5F5;
  transition: color 0.3s ease;
  cursor: pointer; /* Optional: indicates it's interactive */
}

/* Hover effect for h2 */
h2, h5:hover {
  color: black;
}
/* Override only the subscribe button */
.subscribe-btn {
  background-color:#333333; /* Bootstrap gray */
  border-color: #6c757d;
  color: white;
}

.navbar {
  background-color: transparent;
}
.navbar a {
  
}

/* Header Section */
.header {
  background-image: url('bg.png'); /* Put your banner image URL here */
  background-size: cover;
  background-position: center;
  background-repeat: no-repeat;
  color: white;
  padding: 10px 10px;
  text-align: center;
  position: relative;
  overflow: hidden; /* contain overlay */
}

.header::before {
  content: "";
  position: absolute;
  top: 0; left: 0; right: 0; bottom: 0;
  background-color: rgba(0, 0, 0, 0.4); /* Adjust opacity here */
  z-index: 0;
}

.header > * {
  position: relative;
  z-index: 1;
}
.bg-dark-gray {
  background-color:rgba(0,0,0,0.4); /* Dark gray */
}

.news-slide {
  height: 150px;
  background-size: cover;
  background-position: center;
  background-repeat: no-repeat;
  position: relative;
}

.news-slide .carousel-caption {
  background: #2c2c2c;
  padding: 20px;
  border-radius: 5px;
  color: #fff;
  max-width: 100%;
 
}

#newsCarousel {
  padding-top: 0;
  padding-bottom: 0;
  margin-top: 0;
  margin-bottom: 0;
}


.carousel-control-prev-icon,
.carousel-control-next-icon {
  filter: grayscale(100%) brightness(60%);
}


.carousel-control-next-icon {
  background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%236c757d' viewBox='0 0 16 16'%3E%3Cpath d='M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z'/%3E%3C/svg%3E");
}

.carousel-control-prev-icon {
  background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%236c757d' viewBox='0 0 16 16'%3E%3Cpath d='M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z'/%3E%3C/svg%3E");
}


.my-5 {
  margin-bottom: 0 !important/* override Bootstrap default */
}



@media (max-width: 576px) {
  .news-slide {
    height: 300px; /* taller on mobile */
  }
}


  </style>
</head>
<body>
    <?php
$conn = mysqli_connect("tisarana.mysql.domeneshop.no","tisarana","ZiNR7FoMC4FEns4g3ieCFdDtHH","tisarana") ;
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$query = "SELECT dtlevent_id as id FROM dtl_event ORDER BY start_dtl DESC LIMIT 1";
$result = $conn->query($query);

if ($result) {
    $row = mysqli_fetch_assoc($result);
    $count = $row['id'];
}
$conn->close();
?>




  <!-- Navbar -->
 
  <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">
      Tisarana Srilankisk Buddhistforen
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
      data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false"
      aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse justify-content-end text-end" id="navbarNav">
      <ul class="navbar-nav">
		<li class="nav-item"><a class="nav-link" href="https://buddhistforbundet.info/Epost.aspx?Status=1" target="_blank">Register with us</a></li>
        <li class="nav-item"><a class="nav-link" href="#hero">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="#about">About</a></li>
        <li class="nav-item"><a class="nav-link" href="events.php?id=<?php echo $count;?>">Events</a></li>
        
        <li class="nav-item"><a class="nav-link" href="#gallery">Gallery</a></li>
        <li class="nav-item"><a class="nav-link" href="#donate">Donate</a></li>
        <li class="nav-item"><a class="nav-link" href="#contact">Contact</a></li>
        <div id="google_translate_element"></div>

      </ul>
    </div>
  </div>
</nav>

<!-- Top bar with only the logo -->



  <!-- Header Section -->
 <div class="header" id="hero">
    <p></p>
  
 <img src="logo.png" alt="Tisarana Logo" class="img-fluid mb-3" style="max-height: 230px;">
 <h1>
Sri Lanka Buddhist Vihara, Norway</h1>
  <p>Welcome to the official website of the Sri Lankan Buddhist Vihara in Norway. Sri Lankan Buddhist Vihara is a teravada buddhist vihara in Oslo</p>

  <!-- Subscription Form -->
  <div class="container my-5">
      
    <h2 class="text-center mb-4" style="color:#F5F5F5;">Subscribe for Updates</h2>
    <form class="row justify-content-center" action="admin/subscribe.php" method="POST">
      <div class="col-md-6 mb-3">
        <input type="email" class="form-control" name="email" placeholder="Enter your email address" required>
      </div>
      <div class="col-md-2 mb-3">
        <button type="submit" name="subs" class="btn btn-secondary w-100 subscribe-btn">Subscribe</button>
      </div>
    </form>
  </div>
</div>
<!-- News Carousel Section -->
<!-- News Carousel with Background Images and Dark Gray Background -->
<div class="container-fluid px-0 my-0>
  <div id="newsCarousel" class="carousel slide" data-bs-ride="carousel">
    <div class="carousel-inner">
      <?php
      // Reconnect to DB only if not already open
      $conn = mysqli_connect("tisarana.mysql.domeneshop.no","tisarana","ZiNR7FoMC4FEns4g3ieCFdDtHH","tisarana");

      if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
      }

      $sql = "SELECT * FROM news ORDER BY id DESC LIMIT 5;";
      $result = $conn->query($sql);

      if ($result && $result->num_rows > 0) {
        $first = true;
        while ($row = $result->fetch_assoc()) {
          $activeClass = $first ? 'active' : '';
          $first = false;
          ?>
          <div class="carousel-item <?php echo $activeClass; ?> news-slide" style="background-image: url('<?php echo htmlspecialchars($row['image_url'] ?? 'https://via.placeholder.com/1200x500'); ?>');">
            <div class="carousel-caption text-center">
              <h3><?php echo htmlspecialchars($row['title']); ?></h3>
              <p><?php echo htmlspecialchars($row['content']); ?></p>
            </div>
          </div>
          <?php
        }
      } else {
        echo '<div class="carousel-item active news-slide" style="background-image: url(\'https://via.placeholder.com/1200x500?text=No+News\');"><div class="carousel-caption text-center"><h3>No News Available</h3><p>Please check back later.</p></div></div>';
      }

      $conn->close();
      ?>
    </div>

    <!-- Carousel Controls -->
    <button class="carousel-control-prev" type="button" data-bs-target="#newsCarousel" data-bs-slide="prev">
      <span class="carousel-control-prev-icon"></span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#newsCarousel" data-bs-slide="next">
      <span class="carousel-control-next-icon"></span>
    </button>
  </div>
</div>




    <!-- Controls -->
    <button class="carousel-control-prev" type="button" data-bs-target="#newsCarousel" data-bs-slide="prev">
      <span class="carousel-control-prev-icon" aria-hidden="true"></span>
      <span class="visually-hidden">Previous</span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#newsCarousel" data-bs-slide="next">
      <span class="carousel-control-next-icon" aria-hidden="true"></span>
      <span class="visually-hidden">Next</span>
    </button>
  </div>
</div>


  <!-- Main Content -->
<!-- Events Section -->

<div class="container my-5" id="events">
  <h2 class="text-center mb-4">Upcoming Events</h2>
  <div class="row">
      <?php
$conn = mysqli_connect("tisarana.mysql.domeneshop.no","tisarana","ZiNR7FoMC4FEns4g3ieCFdDtHH","tisarana") ;
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$query = "SELECT COUNT(*) as total FROM dtl_event";
$result = $conn->query($query);

if ($result) {
    $row = mysqli_fetch_assoc($result);
    $count = $row['total'];
}

$sql = "SELECT * FROM dtl_event where start_dtl > CURDATE() ORDER BY dtl_event.start_dtl DESC LIMIT 3;";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
  // output data of each row
  while($row = $result->fetch_assoc()) {
      //print_r($row);
    //echo "id: " . $row["id"]. " - Name: " . $row["firstname"]. " " . $row["lastname"]. "<br>";
	?>
	
    <div class="col-md-4 mb-4">
      <div class="card h-100">
      <img src="admin/<?php if($row['imagepath'] != '') { echo $row['imagepath']; } else { echo 'dharma_chakra.jpg'; } ?>" class="card-title text-truncate" style="max-width: 100%; font-size: 1.1rem;" alt="">
        <div class="card-body">
          <h5 class="card-title"><?php echo $row["title"]."<br>";?> on <?php echo date("Y-m-d", strtotime($row["start_dtl"]))?></h5>
          <p class="card-text"><?php //echo $row["event_dsc"];?><a class="btn btn-secondary" href="events.php?id=<?php echo $row["dtlevent_id"];?>">More details</a></p>
          
      </div>
    </div>
   
  </div>
  
  <?php
  }
} else { ?>
  <div class="row justify-content-center text-center"><p>Thank you for your interest in our events! There are no events planned yet. Please check back soon.</p></div>
  <?php
}
$conn->close();
?>
</div>
<!-- About Section -->
<div class="container my-5" id="about">
  <h2 class="text-center mb-4">About Us</h2>
  <div class="row">
    <div class="col-md-4 mb-4">
      <div class="card h-100 text-start">
        <div class="card-body">
          <h5 class="card-title text-start">Vihara</h5>
          <p class="card-text text-start">
            The temple of the Tisarana Sri Lanka Buddhist Association changed the name, from Oslo Buddhist Vihara to Sri Lanka Buddhist Vihara of Norway, in March 2021, after moved to larger premises in Hurdal, 80km north of Oslo.
The chief incumbent Ven Marathugoda Manirathana Thero has served the Oslo
Buddhist Vihara since its establishment in March 2011 and has made a tremendous effort to establish the Sri Lanka Buddhist Vihara of Norway in Hurdal together with Ven. Unapane Pemananda Thero, the Executive Committee and members of Tisarana.
The temple runs according to the Theravada Buddhist principles and Sri Lankan traditions, and has become a landmark for Sri Lankan Buddhists in Norway.
          </p>
        </div>
      </div>
    </div>
   
   
    <div class="col-md-4 mb-4">
      <div class="card h-100 text-start">
        <div class="card-body">
          <h5 class="card-title">Our Vision</h5>
          <p class="card-text">
            The temple facilitates celebrating the main Buddhist events such as Vesak, Poson, Katina, New Year blessings, full moon day retreat programs, and number of other events throughout the year. These Buddhist celebrations are common even in the western countries today. By facilitating this kind of traditional religious celebrations, temple contributes Sri Lankan Buddhist to maintain their cultural roots and transfer those values to the next generation.
Sri Lanka Buddhist Vihara of Norway has implemented number of different programs to improve the spiritual values among the devotees. Some of the activities are
          </p>
        </div>
      </div>
    </div>
   
   
    <div class="col-md-4 mb-4">
      <div class="card h-100 text-start">
        <div class="card-body">
          <h5 class="card-title">Activies</h5>
          <p class="card-text" align="justify">
            <ul>
				
                <i class="bi bi-check-circle-fill"></i> <span>Daily ritual of Buddhists - Puja & personal worship and meditation  Open for anybody who like to participate.</span></br>
                <i class="bi bi-check-circle-fill"></i> <span>Daily Dhamma discussions at 20.30</span></br>
                <i class="bi bi-check-circle-fill"></i> <span>Full moon day retreat programs & weekend retreat programs individual and communal grief work /commemorations<span><br>
                <i class="bi bi-check-circle-fill"></i> <span>Sunday school Daham Pasal for children.</span><br>
                <i class="bi bi-check-circle-fill"></i> <span>Resource center for Norwegian school classes and teachers.</span><br>
                <i class="bi bi-check-circle-fill"></i> <span>Facilitate courses in Buddhism, Buddhist philosophy and meditation.</span>
              </ul>
          </p>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Gallery Section -->

    <?php
    require('newgal.php');
    ?>
  
<!-- Donate section -->
<div class="container my-2" id="donate">
    <div class="row justify-content-center text-center">
    <div class="col-md-8">
    <h2 class="mb-4">Donate</h2>
    <p>Thank you for your interest in supporting us! The donation section is currently under construction. Please check back soon.</p>
    </div>
    </div>
</div>
  
  <!-- Add this inside the <body>, below the booking form -->

<div class="container my-2" id="contact">
  <div class="row justify-content-center text-center">
    <div class="col-md-8">
      <h2 class="mb-4">We are here</h2>
      <p><i class="bi bi-geo-alt-fill"></i> Sri Lanka Buddhist Vihara of Norway, Hurdal, 2090, Norway</p>
    </div>
  </div>
</div>
<!-- Contact Section -->
<div class="container my-3">
  <h2 class="text-center mb-4">Contact Us Via Email</h2>
  <div class="row">
    <!-- Contact Form -->
    <div class="col-md-6 mb-4">
	<?php
session_start();
$form_data = $_SESSION['form_data'] ?? ['name' => '', 'email' => '', 'subject' => '', 'message' => ''];
?>
      <form id="contact" action="mail.php" method="POST">
        <div class="mb-3">
          <label for="contact-name" class="form-label">Full Name</label>
          <input type="text" class="form-control" id="contact-name"  name="name" value="<?= htmlspecialchars($form_data['name']) ?>" required>
        </div>
        <div class="mb-3">
          <label for="contact-email" class="form-label">Email Address</label>
          <input type="email" class="form-control" id="contact-email" name="email" value="<?= htmlspecialchars($form_data['email']) ?>" required>
        </div>
        <div class="mb-3">
        <input placeholder="Type your subject line" type="hidden" value="request from website" name="subject" value="<?= htmlspecialchars($form_data['subject']) ?>" tabindex="4">
        </div>
        <div class="mb-3">
          <label for="contact-message" class="form-label">Your Message</label>
          <textarea class="form-control" id="contact-message" rows="5" name="message"  required><?= htmlspecialchars($form_data['message']) ?></textarea>
        </div>
         <!-- Google reCAPTCHA widget -->
		 <div class="mb-3 g-recaptcha" data-sitekey="6Leo81ErAAAAAB5A_6DC0-c_vwIKZRv6L0KZRTpD"></div>
        
        <button type="submit" class="btn btn-secondary" name="send" id="contact-submit">Send Message</button>
      </form>

    </div>

    <!-- Google Map -->
    <div class="col-md-6 mb-4">
      <div class="ratio ratio-4x3">
          <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1970.2044888308794!2d11.048003215971741!3d60.408816131044176!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x46416812909b753b%3A0x3a0ee3f8c5800d3!2sSri%20Lanka%20Buddhist%20Vihara%20of%20Norway!5e0!3m2!1sen!2sno!4v1656186720890!5m2!1sen!2sno" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        <!--iframe src="src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1970.2044888308794!2d11.048003215971741!3d60.408816131044176!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x46416812909b753b%3A0x3a0ee3f8c5800d3!2sSri%20Lanka%20Buddhist%20Vihara%20of%20Norway!5e0!3m2!1sen!2sno!4v1656186720890!5m2!1sen!2sno" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"
          
          width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"
          referrerpolicy="no-referrer-when-downgrade">
        </iframe-->
      </div>
    </div>
  </div>
</div>


<script>
  window.addEventListener('scroll', function () {
    const navbar = document.querySelector('.navbar');
    if (window.scrollY > 50) {
      navbar.classList.add('scrolled');
    } else {
      navbar.classList.remove('scrolled');
    }
  });
</script>

  <!-- Footer Section -->
<footer class="bg-dark text-white pt-4 pb-2 mt-5">
  <div class="container text-center">
    <div class="mb-3">
      <a href="mailto:post@tisarana.no" class="text-white me-3">
        <i class="bi bi-envelope-fill"></i> post@tisarana.no
      </a>
      <a href="https://www.google.com/maps/place/Sri+Lanka+Buddhist+Vihara+of+Norway/@60.4088161,11.047617,442m/data=!3m2!1e3!4b1!4m6!3m5!1s0x46416812909b753b:0x3a0ee3f8c5800d3!8m2!3d60.4088135!4d11.0501919!16s%2Fg%2F11c0xzydpz?entry=ttu&g_ep=EgoyMDI1MDUyOC4wIKXMDSoASAFQAw%3D%3D" target="_blank" class="text-white me-3">
        <i class="bi bi-geo-alt-fill"></i> Sri Lanka Buddhist Vihara, Norway
      </a>
    </div>

    <div class="mb-3">
      <a href="https://www.facebook.com/TisaranaNorway" class="text-white me-3" target="_blank">
        <i class="bi bi-facebook"></i>
      </a>
      <a href="" class="text-white me-3" target="_blank">
        <i class="bi bi-youtube"></i>
      </a>
      <a href="" class="text-white" target="_blank">
        <i class="bi bi-instagram"></i>
      </a>
    </div>

    <div class="small">
      &copy; 2025 Tisarana Buddhist Vihara. All rights reserved.
    </div>
  </div>
</footer>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
