<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="author" content="Chathura Gunaratne">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Tisarana Sri Lanka Buddhist Vihara</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
  <link rel="icon" href="favicon.ico" type="image/png">
  <style>
    html, body {
      height: 100%;
      margin: 0;
      padding: 0;
    }
    .event-list {
      height: 100%;
      overflow-y: auto;
    }
    .event-details img {
      max-width: 100%;
      height: auto;
    }
    .event-details {
      padding: 20px;
    }
    footer {
      background-color: #343a40;
      color: white;
      text-align: center;
      padding: 15px 0;
    }
    main {
      flex: 1;
      padding-top: 56px; /* Adjust if your navbar height differs */
    }
    .list-group-item.active {
      background-color: #6c757d !important;
      color: #fff !important;
      border-color: #fff !important;
    }
  </style>
</head>
<body class="d-flex flex-column min-vh-100">

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Tisarana Srilankisk Buddhistforen</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
      <ul class="navbar-nav">
        <li class="nav-item"><a class="nav-link" href="https://buddhistforbundet.info/Epost.aspx?Status=1">Register with us</a></li>
        <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="index.php#about">About</a></li>
        <li class="nav-item"><a class="nav-link" href="">Events</a></li>
        <li class="nav-item"><a class="nav-link" href="index.php#gallery">Gallery</a></li>
        <li class="nav-item"><a class="nav-link" href="index.php#donate">Donate</a></li>
        <li class="nav-item"><a class="nav-link" href="index.php#contact">Contact</a></li>
      </ul>
    </div>
  </div>
</nav>

<?php
$conn = mysqli_connect("tisarana.mysql.domeneshop.no","tisarana","ZiNR7FoMC4FEns4g3ieCFdDtHH","tisarana");
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT evt.* FROM dtl_event evt INNER JOIN tbl_events ON evt.event_id = tbl_events.id ORDER BY evt.start_dtl DESC";
$result = $conn->query($sql);

$allEvents = $futureResults = $todayResults = $pastResults = [];
$today = strtotime(date("Y-m-d"));

foreach ($result as $row) {
    $start = strtotime($row["start_dtl"]);
    $allEvents[] = $row;

    if ($start > $today) {
        $futureResults[] = $row;
    } elseif ($start == $today) {
        $todayResults[] = $row;
    } else {
        $pastResults[] = $row;
    }
}

if (empty($futureResults) && empty($todayResults) && empty($pastResults)) {
?>
<main class="mt-5 pt-1">
  <div class="fullscreen-height d-flex flex-column justify-content-center align-items-center">
    <img src="empty_event.png" class="img-fluid" alt="No Events" style="height:300px; width:300px;" />
    <p class="text-center mt-3">
      Thank you for your interest in our events! There are no events planned yet. Please check back soon.
    </p>
  </div>
</main>
<?php
} else {
?>
<main class="mt-5 pt-1">
  <div class="container-fluid h-100">
    <div class="row flex-column flex-md-row flex-grow-1">
      <div class="col-md-4 bg-light event-list p-3" id="eventList">
        <h5>Upcoming Events</h5>
        <div class="list-group mb-4">
        <?php if (!empty($futureResults)) {
            foreach ($futureResults as $index => $row) { ?>
          <a href="#" class="list-group-item list-group-item-action"
             onclick="showEvent(event, 'future', '<?php echo $index ?>', this)">
             <?php echo $row["title"]; ?>
          </a>
        <?php }} else { echo "<p>No events at the moment</p>"; } ?>
        </div>

        <h5>Events happening now</h5>
        <div class="list-group mb-4">
        <?php if (!empty($todayResults)) {
            foreach ($todayResults as $index => $row) { ?>
          <a href="#" class="list-group-item list-group-item-action"
             onclick="showEvent(event, 'today', '<?php echo $index ?>', this)">
             <?php echo $row["title"]; ?>
          </a>
        <?php }} else { echo "<p>No ongoing events at the moment</p>"; } ?>
        </div>

        <h5>Past Events</h5>
        <div class="list-group mb-4">
        <?php if (!empty($pastResults)) {
            foreach ($pastResults as $index => $row) { ?>
          <a href="#" class="list-group-item list-group-item-action"
             onclick="showEvent(event, 'past', '<?php echo $index ?>', this)">
             <?php echo $row["title"]; ?>
          </a>
        <?php }} ?>
        </div>
      </div>
      <div class="col-md-8 event-details d-flex flex-column" id="eventContent">
        <!-- Event details will load here -->
      </div>
    </div>
  </div>
</main>
<?php } ?>

<!-- Footer -->
<footer class="bg-dark text-white pt-4 pb-2">
  <div class="container text-center">
    <div class="mb-3">
      <a href="mailto:post@tisarana.no" class="text-white me-3">
        <i class="bi bi-envelope-fill"></i> post@tisarana.no
      </a>
      <a href="https://www.google.com/maps/place/Sri+Lanka+Buddhist+Vihara+of+Norway" target="_blank" class="text-white me-3">
        <i class="bi bi-geo-alt-fill"></i> Sri Lanka Buddhist Vihara, Norway
      </a>
    </div>
    <div class="mb-3">
      <a href="https://www.facebook.com/TisaranaNorway" class="text-white me-3" target="_blank"><i class="bi bi-facebook"></i></a>
      <a href="" class="text-white me-3" target="_blank"><i class="bi bi-youtube"></i></a>
      <a href="" class="text-white" target="_blank"><i class="bi bi-instagram"></i></a>
    </div>
    <div class="small">
      &copy; 2025 Tisarana Buddhist Vihara. All rights reserved.
    </div>
  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
window.showEvent = function(event, section, key, el) {
  event.preventDefault();

  const eventData = section === 'future'
    ? <?php echo json_encode($futureResults); ?>
    : section === 'past'
    ? <?php echo json_encode($pastResults); ?>
    : <?php echo json_encode($todayResults); ?>;

  const eventItem = eventData[key];
  const startDate = new Date(eventItem.start_dtl);
  const endDate = new Date(eventItem.end_dtl);

  const formattedStart = `${startDate.toLocaleDateString()} at ${startDate.toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'})}`;
  const formattedEnd = `${endDate.toLocaleDateString()} at ${endDate.toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'})}`;

  document.getElementById('eventContent').innerHTML = `
    <h3>${eventItem.title}</h3>
    <div class="d-flex flex-row gap-3">
      <div><strong>Start date:</strong> ${formattedStart}</div>
      <div><strong>End date:</strong> ${formattedEnd}</div>
    </div>
    <div class="mb-3"></div>
    <img src="admin/${eventItem.imagepath}" alt="${eventItem.title}" class="mb-3" style="width: 200px; height: 200px; object-fit: cover;">
    <h4>Description:</h4>
    <p style="white-space: pre-wrap; max-height: 250px; overflow-y: auto">${eventItem.event_dsc}</p>
    <p class="mt-3">
      <button class="btn btn-outline-primary" onclick="loadGalleryModal(${eventItem.event_id}, '${eventItem.title}')">
        View Media Gallery
      </button>
    </p>
  `;

  document.querySelectorAll('.list-group-item').forEach(item => item.classList.remove('active'));
  if (el) el.classList.add('active');
};

window.addEventListener('DOMContentLoaded', function () {
  let section = null, key = null, eventData = null;
  const futureEvents = <?php echo json_encode($futureResults); ?>;
  const todayEvents = <?php echo json_encode($todayResults); ?>;
  const pastEvents = <?php echo json_encode($pastResults); ?>;

  if (futureEvents.length > 0) {
    section = 'future'; key = 0; eventData = futureEvents;
  } else if (todayEvents.length > 0) {
    section = 'today'; key = 0; eventData = todayEvents;
  } else if (pastEvents.length > 0) {
    section = 'past'; key = 0; eventData = pastEvents;
  }

  if (section !== null) {
    const title = eventData[key].title.trim();
    const el = Array.from(document.querySelectorAll('.list-group-item')).find(item => item.textContent.trim() === title);
    showEvent(new Event('click'), section, key, el);
  }
});

function loadGalleryModal(productId, title) {
  const modalBody = document.getElementById('galleryModalBody');
  const modalTitle = document.getElementById('galleryModalLabel');
  modalTitle.textContent = `Media Gallery  ${title}`;
  modalBody.innerHTML = '<div class="text-center my-4">Loading...</div>';

  fetch(`view-gallery.php?product_id=${productId}`)
    .then(response => response.text())
    .then(html => {
      modalBody.innerHTML = html;
      const modal = new bootstrap.Modal(document.getElementById('galleryModal'));
      modal.show();
    })
    .catch(() => {
      modalBody.innerHTML = '<div class="text-danger text-center">Failed to load gallery.</div>';
    });
}
</script>

<!-- Modal for Gallery -->
<div class="modal fade" id="galleryModal" tabindex="-1" aria-labelledby="galleryModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="galleryModalLabel">Media Gallery</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="galleryModalBody">
        <!-- Gallery content will be loaded here -->
      </div>
    </div>
  </div>
</div>

</body>
</html>
