<?php
$target_file = ""; // default to empty, in case of failure

if (isset($_FILES["imageup"]) && $_FILES["imageup"]["error"] == 0) {

    $target_dir = "upload/";
    $file_name = basename($_FILES["imageup"]["name"]);
    $target_path = $target_dir . $file_name;

    $imageFileType = strtolower(pathinfo($target_path, PATHINFO_EXTENSION));

    // Validate image
    $check = getimagesize($_FILES["imageup"]["tmp_name"]);
    if ($check === false) {
        return;
    }

    // Validate file type
    $allowed = ["jpg", "jpeg", "png", "gif"];
    if (!in_array($imageFileType, $allowed)) {
        return;
    }

    // Validate file size (e.g., 5MB max)
    if ($_FILES["imageup"]["size"] > 5000000) {
        return;
    }

    // File exists check (optional: rename instead)
    if (file_exists($target_path)) {
        // Rename file to avoid overwrite
        $unique_name = time() . "_" . $file_name;
        $target_path = $target_dir . $unique_name;
    }

    // Upload
    if (move_uploaded_file($_FILES["imageup"]["tmp_name"], $target_path)) {
        $target_file = $target_path; // &#9989; Final image path for use
    }
}
?>
