<?php
session_start();
?>



<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add News</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-5">
    <h2 class="mb-4"></h2>

    <?php if (isset($message)) echo "<div class='alert alert-info'>$message</div>"; ?>

    <form method="POST" action="addnews.php" class="mb-5">
        <div class="mb-3">
            <label for="title" class="form-label">News Title</label>
            <input type="text" name="title" id="title" class="form-control" placeholder="Enter news title" required>
        </div>

        <div class="mb-3">
            <label for="content" class="form-label">News Content</label>
            <textarea name="content" id="content" rows="6" class="form-control" placeholder="Write your news content..." required></textarea>
        </div>

        <button type="submit" class="btn btn-primary">Post News</button>
    </form>

    <hr>

  <h3>News</h3>

    <?php
    include("db.php");
    $result = $conn->query("SELECT * FROM news ORDER BY created_at DESC");

    while ($row = $result->fetch_assoc()) {
        echo "<div class='card mb-3'>";
        echo "<div class='card-body'>";
        echo "<h5 class='card-title'>" . htmlspecialchars($row['title']) . "</h5>";
        echo "<h6 class='card-subtitle mb-2 text-muted'>Posted by " . htmlspecialchars($row['author']) . " on " . $row['created_at'] . "</h6>";
        echo "<p class='card-text'>" . nl2br(htmlspecialchars($row['content'])) . "</p>";
echo "<div class='mt-3'>";
echo "<a href='editnews.php?id=" . $row['id'] . "' class='btn btn-sm btn-warning me-2'>Edit</a>";
echo "<a href='deletenews.php?id=" . $row['id'] . "' class='btn btn-sm btn-danger' onclick=\"return confirm('Are you sure you want to delete this news item?');\">Delete</a>";
echo "</div>";

echo "</div>"; // closes .card-body
echo "</div>"; // closes .card

        echo "</div>";
        echo "</div>";    
        echo "</div>";




    }
    ?>
</div>

</body>
</html>
	