<?php
session_start();

$timeout_duration = 300;

if (
    !isset($_SESSION['loginstatus']) || $_SESSION['loginstatus'] != 1 ||
    !isset($_SESSION['usertype']) || $_SESSION['usertype'] != 2
) 

{
    header("Location: ../account.php");
    exit;
}

if (isset($_SESSION['logintime']) && (time() - $_SESSION['logintime']) > $timeout_duration) {
    // Session expired
    session_unset();
    session_destroy();
    header("Location: ../account.php?timeout=1");
    exit;
}

// Update logintime to extend session on activity
$_SESSION['logintime'] = time();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Tisarana.no Admin Panel</title>
    <!-- Favicon-->
    <link rel="icon" type="image/x-icon" href="assets/favicon.ico" />
    <!-- Core theme CSS (includes Bootstrap)-->
    <link href="css/styles.css" rel="stylesheet" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
</head>
<body>
    <div class="d-flex" id="wrapper">
        <!-- Sidebar-->
        <div class="border-end bg-white" id="sidebar-wrapper">
            <div class="sidebar-heading border-bottom bg-light">
                <a href="index.php" style="text-decoration:none;"><h3>Dashboard</h3></a>
            </div>
            <div class="list-group list-group-flush">
                <button class="list-group-item list-group-item-action list-group-item-light p-3" id="event">Events</button>
                <button class="list-group-item list-group-item-action list-group-item-light p-3" id="customevent">Customize Event</button>
                <button class="list-group-item list-group-item-action list-group-item-light p-3" id="postphotos">Event Photos</button>
                <button class="list-group-item list-group-item-action list-group-item-light p-3" id="gallery">Gallery</button>
                <button class="list-group-item list-group-item-action list-group-item-light p-3" id="user">User</button>
                <button class="list-group-item list-group-item-action list-group-item-light p-3" id="done">Donations</button>
                <button class="list-group-item list-group-item-action list-group-item-light p-3" id="news">News Blog</button>
            </div>
        </div>
        <!-- Page content wrapper-->
        <div id="page-content-wrapper">
            <!-- Top navigation-->
            <nav class="navbar navbar-expand-lg navbar-light bg-light border-bottom">
                <div class="container-fluid">
                    <button class="btn btn-primary" id="sidebarToggle">Hide/Show</button>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" 
                            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav ms-auto mt-2 mt-lg-0">
                            <li class="nav-item active"><a class="nav-link" href="https://tisarana.no">Visit Site</a></li>
                            <li class="nav-item"><a class="nav-link" href="logout.php">Log-out</a></li>
                        </ul>
                    </div>
                </div>
            </nav>
            <!-- Page content-->
            <div id="container-body"></div>
        </div>
    </div>

    <!-- Bootstrap core JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Core theme JS -->
    <script src="js/scripts.js"></script>

    <script>
    $(document).ready(function () {
        // Load calendar content initially
        $.get('indexcalander.php', function (data) {
            $('#container-body').html(data);
        });

        // Event handlers for sidebar buttons
        $('#event').click(function () {
            $.get('indexcalander.php', function (data) {
                $('#container-body').html(data);
            });
        });
        $('#customevent').click(function () {
            $.get('eventlist.php', function (data) {
                $('#container-body').html(data);
            });
        });
        $('#postphotos').click(function () {
            $.get('eventphotos.php', function (data) {
                $('#container-body').html(data);
            });
        });
        $('#gallery').click(function () {
            $.get('sitegallery.php', function (data) {
                $('#container-body').html(data);
            });
        });
        $('#user').click(function () {
            $.get('viewuser.php', function (data) {
                $('#container-body').html(data);
            });
        });
        $('#done').click(function () {
            $.get('donation.php', function (data) {
                $('#container-body').html(data);
            });
        });
        $('#news').click(function () {
            $.get('news.php', function (data) {
                $('#container-body').html(data);
            });
        });
    });
    </script>
</body>
</html>


    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title>Tisarana.no Admin Panel</title>
        <!-- Favicon-->
        <link rel="icon" type="image/x-icon" href="assets/favicon.ico" />
        <!-- Core theme CSS (includes Bootstrap)-->
        <link href="css/styles.css" rel="stylesheet" />
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    </head>
	
		
    <body>
        
           


        <!-- Bootstrap core JS-->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
        <!-- Core theme JS-->
        <script src="js/scripts.js"></script>
        
        
        
        	
    </body>
</html>
