<?php
ob_start(); // Optional: handle output buffering

if (isset($_POST['submit'])) {
    include('db.php'); // This should define $conn

    if (isset($_FILES['image']) && !empty($_FILES['image']['name'][0])) {
        $pid = intval($_POST["pid"]);
        $allowedExtensions = array('jpeg', 'jpg', 'png', 'gif', 'mp4');

        foreach ($_FILES['image']['tmp_name'] as $key => $tmpName) {
            $originalName = $_FILES['image']['name'][$key];
            $tmpFile = $_FILES['image']['tmp_name'][$key];
            $ext = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));

            if (in_array($ext, $allowedExtensions)) {
                $safeFilename = preg_replace("/[^a-zA-Z0-9_\-]/", "_", pathinfo($originalName, PATHINFO_FILENAME));
                $finalName = $safeFilename . '.' . $ext;

                // Prevent filename conflict
                if (file_exists('gallery/' . $finalName)) {
                    $finalName = $safeFilename . '_' . time() . '.' . $ext;
                }

                move_uploaded_file($tmpFile, 'gallery/' . $finalName);

                $createdTime = date('Y-m-d H:i:s');

                // Detect media type: 0 = image, 1 = video
                $media = ($ext === 'mp4') ? 1 : 0;

                $sql = "INSERT INTO gallery (product_id, imagepath, media_type, time) VALUES (?, ?, ?, ?)";
                $stmt = mysqli_prepare($conn, $sql);

                if ($stmt) {
                    mysqli_stmt_bind_param($stmt, 'isis', $pid, $finalName, $media, $createdTime);
                    mysqli_stmt_execute($stmt);
                    mysqli_stmt_close($stmt);
                } else {
                    echo "Error in SQL prepare: " . mysqli_error($conn);
                }
            }
        }
    }

    header("Location: toast.php?msg=Record+updated+successfully!");
    exit(); // Important
}
?>
