<?php
require_once "db.php";

$title = isset($_POST['title']) ? $_POST['title'] : "";
$start = isset($_POST['start']) ? $_POST['start'] : "";
$end   = isset($_POST['end'])   ? $_POST['end']   : "";

$conn->begin_transaction(); // Start a transaction

try {
    // First insert into tbl_events
    $sqlInsert1 = "INSERT INTO tbl_events (title, start, end) VALUES (?, ?, ?)";
    $stmt1 = $conn->prepare($sqlInsert1);
    $stmt1->bind_param("sss", $title, $start, $end);
    $stmt1->execute();

    // Get the actual last inserted ID (event_id)
    $event_id = $conn->insert_id;

    // Then insert into dtl_event with correct foreign key
    $sqlInsert2 = "INSERT INTO dtl_event (title, start_dtl, end_dtl, event_id) VALUES (?, ?, ?, ?)";
    $stmt2 = $conn->prepare($sqlInsert2);
    $stmt2->bind_param("sssi", $title, $start, $end, $event_id);
    $stmt2->execute();

    $conn->commit(); // Commit both inserts

    echo "Records inserted successfully into both tables.";

    // Clean up
    $stmt1->close();
    $stmt2->close();
} catch (Exception $e) {
    $conn->rollback(); // Undo changes on error
    echo "Transaction failed: " . $e->getMessage();
}

$conn->close();
?>
